/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.backend.trust_list;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.menu.MenuBase;
import com.simibubi.create.foundation.utility.Components;
import dev.ithundxr.createnumismatics.content.backend.Trusted;
import dev.ithundxr.createnumismatics.content.backend.trust_list.TrustListHolder;
import dev.ithundxr.createnumismatics.content.bank.IDCardItem;
import dev.ithundxr.createnumismatics.content.bank.IDCardSlot;
import dev.ithundxr.createnumismatics.content.coins.CoinItem;
import dev.ithundxr.createnumismatics.content.depositor.ProtectedScrollOptionBehaviour;
import dev.ithundxr.createnumismatics.registry.NumismaticsMenuTypes;
import dev.ithundxr.createnumismatics.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class TrustListMenu
extends MenuBase<TrustListHolder> {
    public static final int CARD_SLOTS = 27;
    public static final int PLAYER_INV_START_INDEX = 27;
    public static final int PLAYER_HOTBAR_END_INDEX = 36;
    public static final int PLAYER_INV_END_INDEX = 63;
    ItemStack renderedItem;

    public TrustListMenu(MenuType<?> type, int id, Inventory inv, FriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
    }

    protected TrustListMenu(MenuType<?> type, int id, Inventory inv, TrustListHolder contentHolder, ItemStack renderedItem) {
        super(type, id, inv, (Object)contentHolder);
        this.renderedItem = renderedItem;
    }

    public static MenuProvider provider(final TrustListHolder contentHolder, final ItemStack renderedItem) {
        return new MenuProvider(){

            @NotNull
            public Component m_5446_() {
                return Components.translatable((String)"gui.numismatics.trust_list");
            }

            public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
                return new TrustListMenu((MenuType)NumismaticsMenuTypes.TRUST_LIST.get(), i, inventory, contentHolder, renderedItem);
            }
        };
    }

    protected TrustListHolder createOnClient(FriendlyByteBuf extraData) {
        SyncedBlockEntity syncedBE;
        this.renderedItem = extraData.m_130267_();
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        BlockEntity blockEntity = world.m_7702_(extraData.m_130135_());
        if (blockEntity instanceof SyncedBlockEntity && (syncedBE = (SyncedBlockEntity)blockEntity) instanceof TrustListHolder) {
            TrustListHolder trustListHolder = (TrustListHolder)syncedBE;
            syncedBE.readClient(extraData.m_130260_());
            return trustListHolder;
        }
        return null;
    }

    protected void initAndReadInventory(TrustListHolder contentHolder) {
    }

    protected void addSlots() {
        int x = 16;
        int y = 21;
        for (int i = 0; i < 27; ++i) {
            if (i % 9 == 0 && i > 0) {
                x = 16;
                y += 18;
            }
            this.m_38897_(new IDCardSlot.BoundIDCardSlot(((TrustListHolder)this.contentHolder).getTrustListBackingContainer(), i, x, y));
            x += 18;
        }
        this.addPlayerSlots(40, 130);
    }

    protected void saveData(TrustListHolder contentHolder) {
    }

    public ItemStack m_7648_(@NotNull Player player, int index) {
        Slot clickedSlot = (Slot)this.f_38839_.get(index);
        if (!clickedSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack slotStack = CoinItem.clearDisplayedCount(clickedSlot.m_7993_());
        ItemStack returnStack = slotStack.m_41777_();
        if (index < 27) {
            int count = slotStack.m_41613_();
            if (!this.m_38903_(slotStack, 27, 63, false)) {
                return ItemStack.f_41583_;
            }
            returnStack = ItemStack.f_41583_;
            clickedSlot.m_6201_(count);
        } else {
            if (slotStack.m_41720_() instanceof IDCardItem && IDCardItem.isBound(slotStack) && !this.m_38903_(slotStack, 0, 27, false)) {
                return ItemStack.f_41583_;
            }
            if (index >= 27 && index < 36 && !this.m_38903_(slotStack, 36, 63, false)) {
                return ItemStack.f_41583_;
            }
            if (index >= 36 && index < 63 && !this.m_38903_(slotStack, 27, 36, false)) {
                return ItemStack.f_41583_;
            }
        }
        if (slotStack.m_41619_()) {
            clickedSlot.m_5852_(ItemStack.f_41583_);
        } else {
            clickedSlot.m_6654_();
        }
        return returnStack;
    }

    protected boolean m_38903_(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        ItemStack itemStack;
        Slot slot;
        boolean bl = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.m_41753_() && startIndex >= 27) {
            while (!stack.m_41619_() && (reverseDirection ? i >= startIndex : i < endIndex)) {
                slot = (Slot)this.f_38839_.get(i);
                itemStack = slot.m_7993_();
                if (!itemStack.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack)) {
                    int j = itemStack.m_41613_() + stack.m_41613_();
                    if (j <= stack.m_41741_()) {
                        stack.m_41764_(0);
                        itemStack.m_41764_(j);
                        slot.m_6654_();
                        bl = true;
                    } else if (itemStack.m_41613_() < stack.m_41741_()) {
                        stack.m_41774_(stack.m_41741_() - itemStack.m_41613_());
                        itemStack.m_41764_(stack.m_41741_());
                        slot.m_6654_();
                        bl = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.m_41619_()) {
            int n = i = reverseDirection ? endIndex - 1 : startIndex;
            while (reverseDirection ? i >= startIndex : i < endIndex) {
                slot = (Slot)this.f_38839_.get(i);
                itemStack = slot.m_7993_();
                if (itemStack.m_41619_() && slot.m_5857_(stack)) {
                    if (stack.m_41613_() > slot.m_6641_()) {
                        slot.m_269060_(stack.m_41620_(slot.m_6641_()));
                    } else {
                        slot.m_269060_(stack.m_41620_(stack.m_41613_()));
                    }
                    slot.m_6654_();
                    bl = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return bl;
    }

    public static <BE extends SmartBlockEntity & Trusted> ScrollOptionBehaviour<TrustListSham> makeConfigureButton(final BE be, ValueBoxTransform slot, final ItemStack displayStack) {
        return new ProtectedScrollOptionBehaviour<TrustListSham>(TrustListSham.class, (Component)Components.translatable((String)"numismatics.trust_list.configure"), be, slot, be::isTrusted){

            public void onShortInteract(Player player, InteractionHand hand, Direction side) {
                if (((Trusted)be).isTrusted(player) && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    Utils.openScreen(serverPlayer, TrustListMenu.provider((TrustListHolder)be, displayStack), buf -> {
                        buf.m_130055_(displayStack);
                        be.sendToMenu(buf);
                    });
                } else {
                    super.onShortInteract(player, hand, side);
                }
            }

            public boolean acceptsValueSettings() {
                return false;
            }
        };
    }

    public static <BE extends SmartBlockEntity & Trusted> void openMenu(BE be, ServerPlayer player, ItemStack displayStack) {
        if (((Trusted)be).isTrusted((Player)player)) {
            Utils.openScreen(player, TrustListMenu.provider((TrustListHolder)be, displayStack), buf -> {
                buf.m_130055_(displayStack);
                be.sendToMenu(buf);
            });
        }
    }

    public static enum TrustListSham implements INamedIconOptions
    {
        NONE;


        public AllIcons getIcon() {
            return AllIcons.I_VIEW_SCHEDULE;
        }

        public String getTranslationKey() {
            return "numismatics.trust_list.configure";
        }
    }
}

